/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.BaselineStrategy;
import net.sf.mpxj.DefaultBaselineStrategy;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;

public class ProjectConfig {
    private final ProjectFile m_parent;
    private boolean m_autoWBS = true;
    private boolean m_autoOutlineLevel = true;
    private boolean m_autoOutlineNumber = true;
    private boolean m_autoTaskUniqueID = true;
    private boolean m_autoCalendarUniqueID = true;
    private boolean m_autoAssignmentUniqueID = true;
    private boolean m_autoTaskID = true;
    private boolean m_autoResourceUniqueID = true;
    private boolean m_autoResourceID = true;
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_assignmentUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;
    private boolean m_completeThroughIsNextWorkStart;
    private BaselineStrategy m_baselineStrategy = new DefaultBaselineStrategy();

    public ProjectConfig(ProjectFile projectFile) {
        this.m_parent = projectFile;
    }

    public void setAutoWBS(boolean flag) {
        this.m_autoWBS = flag;
    }

    public void setAutoOutlineLevel(boolean flag) {
        this.m_autoOutlineLevel = flag;
    }

    public void setAutoOutlineNumber(boolean flag) {
        this.m_autoOutlineNumber = flag;
    }

    public void setAutoTaskUniqueID(boolean flag) {
        this.m_autoTaskUniqueID = flag;
    }

    public void setAutoCalendarUniqueID(boolean flag) {
        this.m_autoCalendarUniqueID = flag;
    }

    public void setAutoAssignmentUniqueID(boolean flag) {
        this.m_autoAssignmentUniqueID = flag;
    }

    public void setAutoTaskID(boolean flag) {
        this.m_autoTaskID = flag;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoAssignmentUniqueID() {
        return this.m_autoAssignmentUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public void setAutoResourceUniqueID(boolean flag) {
        this.m_autoResourceUniqueID = flag;
    }

    public void setAutoResourceID(boolean flag) {
        this.m_autoResourceID = flag;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getNextTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    public int getNextCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getNextAssignmentUniqueID() {
        return ++this.m_assignmentUniqueID;
    }

    public int getNextTaskID() {
        return ++this.m_taskID;
    }

    public int getNextResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getNextResourceID() {
        return ++this.m_resourceID;
    }

    public boolean getCompleteThroughIsNextWorkStart() {
        return this.m_completeThroughIsNextWorkStart;
    }

    public void setCompleteThroughIsNextWorkStart(boolean completeThroughIsNextWorkStart) {
        this.m_completeThroughIsNextWorkStart = completeThroughIsNextWorkStart;
    }

    public void updateUniqueCounters() {
        this.updateTaskUniqueCounter();
        this.updateResourceUniqueCounter();
        this.updateCalendarUniqueCounter();
        this.updateAssignmentUniqueCounter();
    }

    public void updateTaskUniqueCounter() {
        for (Task task : this.m_parent.getTasks()) {
            int uniqueID = NumberHelper.getInt(task.getUniqueID());
            if (uniqueID <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = uniqueID;
        }
    }

    public void updateResourceUniqueCounter() {
        for (Resource resource : this.m_parent.getResources()) {
            int uniqueID = NumberHelper.getInt(resource.getUniqueID());
            if (uniqueID <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = uniqueID;
        }
    }

    public void updateCalendarUniqueCounter() {
        for (ProjectCalendar calendar : this.m_parent.getCalendars()) {
            int uniqueID = NumberHelper.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
    }

    public void updateAssignmentUniqueCounter() {
        for (ResourceAssignment assignment : this.m_parent.getResourceAssignments()) {
            int uniqueID = NumberHelper.getInt(assignment.getUniqueID());
            if (uniqueID <= this.m_assignmentUniqueID) continue;
            this.m_assignmentUniqueID = uniqueID;
        }
    }

    public BaselineStrategy getBaselineStrategy() {
        return this.m_baselineStrategy;
    }

    public void setBaselineStrategy(BaselineStrategy strategy) {
        this.m_baselineStrategy = strategy;
    }
}

