﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/CascadingControlConfiguration.h>
#include <aws/quicksight/model/CommitMode.h>
#include <aws/quicksight/model/DropDownControlDisplayOptions.h>
#include <aws/quicksight/model/ParameterSelectableValues.h>
#include <aws/quicksight/model/SheetControlListType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>A control to display a dropdown list with buttons that are used to select a
 * single value.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ParameterDropDownControl">AWS
 * API Reference</a></p>
 */
class ParameterDropDownControl {
 public:
  AWS_QUICKSIGHT_API ParameterDropDownControl() = default;
  AWS_QUICKSIGHT_API ParameterDropDownControl(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API ParameterDropDownControl& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the <code>ParameterDropDownControl</code>.</p>
   */
  inline const Aws::String& GetParameterControlId() const { return m_parameterControlId; }
  inline bool ParameterControlIdHasBeenSet() const { return m_parameterControlIdHasBeenSet; }
  template <typename ParameterControlIdT = Aws::String>
  void SetParameterControlId(ParameterControlIdT&& value) {
    m_parameterControlIdHasBeenSet = true;
    m_parameterControlId = std::forward<ParameterControlIdT>(value);
  }
  template <typename ParameterControlIdT = Aws::String>
  ParameterDropDownControl& WithParameterControlId(ParameterControlIdT&& value) {
    SetParameterControlId(std::forward<ParameterControlIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The title of the <code>ParameterDropDownControl</code>.</p>
   */
  inline const Aws::String& GetTitle() const { return m_title; }
  inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }
  template <typename TitleT = Aws::String>
  void SetTitle(TitleT&& value) {
    m_titleHasBeenSet = true;
    m_title = std::forward<TitleT>(value);
  }
  template <typename TitleT = Aws::String>
  ParameterDropDownControl& WithTitle(TitleT&& value) {
    SetTitle(std::forward<TitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source parameter name of the <code>ParameterDropDownControl</code>.</p>
   */
  inline const Aws::String& GetSourceParameterName() const { return m_sourceParameterName; }
  inline bool SourceParameterNameHasBeenSet() const { return m_sourceParameterNameHasBeenSet; }
  template <typename SourceParameterNameT = Aws::String>
  void SetSourceParameterName(SourceParameterNameT&& value) {
    m_sourceParameterNameHasBeenSet = true;
    m_sourceParameterName = std::forward<SourceParameterNameT>(value);
  }
  template <typename SourceParameterNameT = Aws::String>
  ParameterDropDownControl& WithSourceParameterName(SourceParameterNameT&& value) {
    SetSourceParameterName(std::forward<SourceParameterNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The display options of a control.</p>
   */
  inline const DropDownControlDisplayOptions& GetDisplayOptions() const { return m_displayOptions; }
  inline bool DisplayOptionsHasBeenSet() const { return m_displayOptionsHasBeenSet; }
  template <typename DisplayOptionsT = DropDownControlDisplayOptions>
  void SetDisplayOptions(DisplayOptionsT&& value) {
    m_displayOptionsHasBeenSet = true;
    m_displayOptions = std::forward<DisplayOptionsT>(value);
  }
  template <typename DisplayOptionsT = DropDownControlDisplayOptions>
  ParameterDropDownControl& WithDisplayOptions(DisplayOptionsT&& value) {
    SetDisplayOptions(std::forward<DisplayOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type parameter name of the <code>ParameterDropDownControl</code>.</p>
   */
  inline SheetControlListType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(SheetControlListType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline ParameterDropDownControl& WithType(SheetControlListType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of selectable values that are used in a control.</p>
   */
  inline const ParameterSelectableValues& GetSelectableValues() const { return m_selectableValues; }
  inline bool SelectableValuesHasBeenSet() const { return m_selectableValuesHasBeenSet; }
  template <typename SelectableValuesT = ParameterSelectableValues>
  void SetSelectableValues(SelectableValuesT&& value) {
    m_selectableValuesHasBeenSet = true;
    m_selectableValues = std::forward<SelectableValuesT>(value);
  }
  template <typename SelectableValuesT = ParameterSelectableValues>
  ParameterDropDownControl& WithSelectableValues(SelectableValuesT&& value) {
    SetSelectableValues(std::forward<SelectableValuesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The values that are displayed in a control can be configured to only show
   * values that are valid based on what's selected in other controls.</p>
   */
  inline const CascadingControlConfiguration& GetCascadingControlConfiguration() const { return m_cascadingControlConfiguration; }
  inline bool CascadingControlConfigurationHasBeenSet() const { return m_cascadingControlConfigurationHasBeenSet; }
  template <typename CascadingControlConfigurationT = CascadingControlConfiguration>
  void SetCascadingControlConfiguration(CascadingControlConfigurationT&& value) {
    m_cascadingControlConfigurationHasBeenSet = true;
    m_cascadingControlConfiguration = std::forward<CascadingControlConfigurationT>(value);
  }
  template <typename CascadingControlConfigurationT = CascadingControlConfiguration>
  ParameterDropDownControl& WithCascadingControlConfiguration(CascadingControlConfigurationT&& value) {
    SetCascadingControlConfiguration(std::forward<CascadingControlConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The visibility configuration of the Apply button on a
   * <code>ParameterDropDownControl</code>.</p>
   */
  inline CommitMode GetCommitMode() const { return m_commitMode; }
  inline bool CommitModeHasBeenSet() const { return m_commitModeHasBeenSet; }
  inline void SetCommitMode(CommitMode value) {
    m_commitModeHasBeenSet = true;
    m_commitMode = value;
  }
  inline ParameterDropDownControl& WithCommitMode(CommitMode value) {
    SetCommitMode(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_parameterControlId;

  Aws::String m_title;

  Aws::String m_sourceParameterName;

  DropDownControlDisplayOptions m_displayOptions;

  SheetControlListType m_type{SheetControlListType::NOT_SET};

  ParameterSelectableValues m_selectableValues;

  CascadingControlConfiguration m_cascadingControlConfiguration;

  CommitMode m_commitMode{CommitMode::NOT_SET};
  bool m_parameterControlIdHasBeenSet = false;
  bool m_titleHasBeenSet = false;
  bool m_sourceParameterNameHasBeenSet = false;
  bool m_displayOptionsHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_selectableValuesHasBeenSet = false;
  bool m_cascadingControlConfigurationHasBeenSet = false;
  bool m_commitModeHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
