/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.threadpool.ThreadPool;

public class RolesMappingApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/rolesmapping"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/rolesmapping"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/rolesmapping/{name}")));
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addLegacyRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/rolesmapping", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/rolesmapping/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.DELETE, "/rolesmapping/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/rolesmapping/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PATCH, "/rolesmapping", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PATCH, "/rolesmapping/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")));

    @Inject
    public RolesMappingApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.ROLESMAPPING, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(builder -> builder.onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler));
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    @Override
    protected CType<?> getConfigType() {
        return CType.ROLESMAPPING;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return RolesMappingApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return RolesMappingApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.onConfigChange(securityConfiguration).map(this::validateRole);
            }

            private ValidationResult<SecurityConfiguration> validateRole(SecurityConfiguration securityConfiguration) throws IOException {
                return RolesMappingApiAction.this.loadConfiguration(CType.ROLES, false, false).map(rolesConfiguration -> this.validateRoles(List.of(securityConfiguration.entityName()), (SecurityDynamicConfiguration<?>)rolesConfiguration)).map(ignore -> ValidationResult.success(securityConfiguration));
            }

            @Override
            public ValidationResult<SecurityConfiguration> isAllowedToChangeImmutableEntity(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.isAllowedToChangeImmutableEntity(securityConfiguration).map(this::isAllowedToChangeRoleMappingWithRestAdminPermissions);
            }

            public ValidationResult<SecurityConfiguration> isAllowedToChangeRoleMappingWithRestAdminPermissions(SecurityConfiguration securityConfiguration) throws IOException {
                return RolesMappingApiAction.this.loadConfiguration(CType.ROLES, false, false).map(rolesConfiguration -> this.isAllowedToChangeEntityWithRestAdminPermissions(SecurityConfiguration.of(securityConfiguration.entityName(), rolesConfiguration))).map(ignore -> ValidationResult.success(securityConfiguration));
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return RolesMappingApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Set<String> mandatoryOrKeys() {
                        return ImmutableSet.of((Object)"and_backend_roles", (Object)"backend_roles", (Object)"hosts", (Object)"users");
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        if (this.isCurrentUserAdmin()) {
                            allowedKeys.put((Object)"hidden", (Object)RequestContentValidator.DataType.BOOLEAN);
                            allowedKeys.put((Object)"reserved", (Object)RequestContentValidator.DataType.BOOLEAN);
                        }
                        return allowedKeys.put((Object)"backend_roles", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"and_backend_roles", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"hosts", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"users", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"description", (Object)RequestContentValidator.DataType.STRING).build();
                    }
                });
            }
        };
    }
}

