/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.KEM;
import com.jcraft.jsch.annotations.SuppressForbiddenApi;
import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;

public class SNTRUP761
implements KEM {
    SNTRUPrimeKEMExtractor extractor;
    SNTRUPrimePublicKeyParameters publicKey;

    @Override
    public void init() throws Exception {
        SNTRUPrimeKeyPairGenerator kpg = new SNTRUPrimeKeyPairGenerator();
        kpg.init((KeyGenerationParameters)new SNTRUPrimeKeyGenerationParameters(new SecureRandom(), SNTRUP761.sntrup761()));
        AsymmetricCipherKeyPair kp = kpg.generateKeyPair();
        this.extractor = new SNTRUPrimeKEMExtractor((SNTRUPrimePrivateKeyParameters)kp.getPrivate());
        this.publicKey = (SNTRUPrimePublicKeyParameters)kp.getPublic();
    }

    @Override
    public byte[] getPublicKey() throws Exception {
        return this.publicKey.getEncoded();
    }

    @Override
    public byte[] decapsulate(byte[] encapsulation) throws Exception {
        return this.extractor.extractSecret(encapsulation);
    }

    @SuppressForbiddenApi(value={"jdk-reflection"})
    static SNTRUPrimeParameters sntrup761() throws Exception {
        if (SNTRUPrimeParameters.sntrup761.getSessionKeySize() == 256) {
            return SNTRUPrimeParameters.sntrup761;
        }
        Constructor c = SNTRUPrimeParameters.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        c.setAccessible(true);
        return (SNTRUPrimeParameters)c.newInstance("sntrup761", 761, 4591, 286, 1158, 1007, 1158, 1763, 32);
    }
}

